<?php

namespace backend\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use common\models\Networks;

/**
 * NetworksSearch represents the model behind the search form about `common\models\Networks`.
 */
class NetworksSearch extends Networks
{
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['id', 'destination', 'ipint', 'ipintto'], 'integer'],
            [['ip', 'comment'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Networks::find();

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        $query->andFilterWhere([
            'id' => $this->id,
            'destination' => $this->destination,
            'ipint' => $this->ipint,
            'ipintto' => $this->ipintto,
        ]);

        $query->andFilterWhere(['like', 'ip', $this->ip])
            ->andFilterWhere(['like', 'comment', $this->comment]);

        return $dataProvider;
    }
}
